  '' PCF8574 Demo - REFER TO GUI
  OPTION BASE 0
  OPTION AUTORUN ON
  CONST ADDRESS = &H20
  CONST C.BUTTON=RGB(WHITE)
  ' globals used by Sub DrawButton
  Dim Integer key_coord(9, 5)
  Dim String key_caption(9)
  DIM INTEGER I   ''for loops
  DIM INTEGER OUTSTATE
  DIM INTEGER BUTTON
  DIM INTEGER BITS(8)
  BITS(0)=1
  OUTSTATE = 0
  ''STARTUP
  I2C OPEN 400,100    ''PCA9685 can work up to 1MHz, 400 kHz is Micromite limit
  CLS
  DrawButton 0, 0, MM.HRES\4, 0, MM.HRES\2, 30, C.BUTTON, "READ"
  DrawButton 1, 0, 281, 40, 38, 38, C.BUTTON, "0"
  FOR I = 1 to 7
    DrawButton I+1, 0, (7-I)*40+1, 40, 38, 38, C.BUTTON, STR$(I)
    BITS(I)=BITS(I-1)*2
  NEXT I
  TEXT 160,90,"OUTPUT",CM,,,C.BUTTON
  TEXT 160,170,"INPUT",CM,,,C.BUTTON
  SHOWREADRESULT
  DO
    BUTTON=CheckButtonPress(0,8)
    if BUTTON > -1 THEN
      PAUSE 100
      CheckButtonRelease BUTTON
      IF BUTTON =0 THEN SHOWREADRESULT
      IF BUTTON >0 THEN
        OUTSTATE=OUTSTATE XOR (BITS(BUTTON-1))
        PCF8574WRITE(ADDRESS,OUTSTATE)
        SHOWOUTSTATE
        SHOWREADRESULT
      ENDIF
    ENDIF
  LOOP
END
  
SUB PCF8574WRITE(A AS INTEGER, D AS INTEGER)
  I2C WRITE A,0,1,D
END SUB
  
FUNCTION PCF8574READ(A AS INTEGER)
  I2C READ A,0,1,PCF8574READ
END FUNCTION
  
SUB SHOWREADRESULT
  LOCAL INTEGER R,B
  LOCAL STRING D$
  R=PCF8574READ(ADDRESS)
  B=128
  FOR I = 7 to 0 step -1
    D$="0"
    if (R AND B) >0 then D$="1"
    TEXT (7-I)*40+20,210,D$,CM,,,C.BUTTON
    B=B\2
  NEXT I
END SUB
  
SUB SHOWOUTSTATE
  LOCAL INTEGER R,B
  LOCAL STRING D$
  R=OUTSTATE
  B=128
  FOR I = 7 to 0 step -1
    D$="0"
    if (R AND B) >0 then D$="1"
    TEXT (7-I)*40+20,130,D$,CM,,,C.BUTTON
    B=B\2
  NEXT I
END SUB
  
  '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  ' Draw buttons and get button presses
  '
  ' The subrouting DrawButton will draw a button (normally used when drawing
  ' the screen for input).
  '
  ' The function CheckButtonPress() will check if a button has been touched.
  ' If it has it will set it to selected (reverse video) and return with the
  ' button's number.
  '
  ' The subroutine CheckButtonRelease will wait for the touch to be released
  ' and will then draw the button as normal.
  '
  ' These routines use the global arrays key_coord() and key_caption() to
  ' track the coordinates and size of each button and save its caption.
  '
  '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
  
  ' check if a button has been touch and animate the button's image
  ' returns the button's number
Function CheckButtonPress(startn As Integer, endn As Integer) As Integer
  Local Integer xt, yellowt, n
  
  CheckButtonPress = -1
  If Touch(x) <> -1 Then
    ' we have a touch
    xt = Touch(x)
    yellowt = Touch(y)
    ' scan the array key_coord() to see if the touch was within the
    ' boundaries of a button
    For n = startn To endn
      If xt > key_coord(n,0) And xt < key_coord(n,0) + key_coord(n,2) And yellowt > key_coord(n,1) And yellowt < key_coord(n,1) + key_coord(n,3) Then
        ' we have a button press
        ' draw the button as pressed
        DrawButton n, 2
        CheckButtonPress = n
        Exit For
      EndIf
    Next n
  EndIf
End Function
  
  
  ' wait for the touch to be released and then draw the button as normal
Sub CheckButtonRelease n As Integer
  ' if a button is currently down check if it has been released
  Do While Touch(x) <> -1 : Loop   ' wait for the button to be released
  DrawButton n, 1                  ' draw the button as normal (ie, not pressed)
End Sub
  
  ' draw a button
Sub DrawButton n As Integer, mode As Integer, x As Integer, y As Integer, w As Integer, h As Integer, c As Integer, s As String
  Local Integer bc, fc
  
  If mode = 0 Then
    key_coord(n,0) = x : key_coord(n,1) = y : key_coord(n,2) = w : key_coord(n,3) = h
    key_coord(n,4) = c : key_caption(n) = s
  EndIf
  
  If mode > 1 Then
    bc = key_coord(n,4) : fc = 0    ' draw in reverse video if it is being touched
  Else
    bc = 0 : fc = key_coord(n,4)    ' a normal (untouched) button
  EndIf
  
  RBox key_coord(n,0), key_coord(n,1), key_coord(n,2), key_coord(n,3), , key_coord(n,4), bc)
  Text key_coord(n,0) + key_coord(n,2)/2, key_coord(n,1) + key_coord(n,3)/2, key_caption(n), CM, , , fc, bc
End Sub

